﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<script runat="server">

    public class Params: ContextBase {
        public Params(Context context): base(context) {
        }
    
        bool gotówka = true;
        [Priority(1)]
        public bool Gotówka {
            get { return gotówka; }
            set {
                gotówka = value;
                if (!gotówka)
                    ror = true;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool ror = true;
        [Priority(2)]
        public bool ROR {
            get { return ror; }
            set {
                ror = value;
                if (!ror)
                    gotówka = true;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool podsumowanie = false;
        [Priority(3)]
        [Caption("Tylko podsumowanie")]
        public bool Podsumowanie {
            get { return podsumowanie; }
            set {
                podsumowanie = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        if (!pars.Gotówka) {
            colGotowka.Visible = false;
            colLpGotowka.Visible = false;
        }
        if (!pars.ROR) {
            colRor.Visible = false;
            colLpRor.Visible = false;
        }
    
        Row[] rows = (Row[])dc[typeof(Row[])];
        if (pars.Podsumowanie)
            wyplatyRepeater.Visible = false;
        else
            wyplatyRepeater.DataSource = rows;
        Grid2.DataSource = rows;
    }
    
    static void Message(object value) {
    }
    
    void Grid2_BeforeRow(Object sender, RowEventArgs args) {
        ListaPlac lista = (ListaPlac)args.Row;
        decimal gotówka = 0m;
        decimal inne = 0m;
        foreach (Wyplata wyplata in lista.Wyplaty) {
            gotówka += wyplata.Gotówka.Value;
            inne += wyplata.Inne.Value;
        }
    
        colLpGotowka.EditValue = gotówka;
        colLpRor.EditValue = inne;
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Zestawienie wypłat gotówka/ROR</title> 
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie wypłat gotówka/ROR" runat="server"></eb:ReportHeader>
        <ea:DataRepeater id="wyplatyRepeater" runat="server" Width="100%" RowTypeName="Soneta.Place.ListaPlac,Soneta.KadryPlace">
            <ea:SectionMarker id="SectionMarker2" runat="server"></ea:SectionMarker>
            <p>
                Lista płac: 
                <ea:DataLabel id="DataLabel1" runat="server" DataMember="Numer.NumerPelny"></ea:DataLabel>
                , data: 
                <ea:DataLabel id="DataLabel2" runat="server" DataMember="Data"></ea:DataLabel>
                , data wypłaty: 
                <ea:DataLabel id="DataLabel3" runat="server" DataMember="DataWyplaty"></ea:DataLabel>
                <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Place.Wyplata,Soneta.KadryPlace" DataMember="Wyplaty">
                    <Columns>
                        <ea:GridColumn Width="4" Align="Right" DataMember="Numer.Numer" Caption="LP."></ea:GridColumn>
                        <ea:GridColumn DataMember="Pracownik.ImięNazwisko" Caption="Imię i nazwisko"></ea:GridColumn>
                        <ea:GridColumn Width="16" Align="Right" DataMember="Got&#243;wka" Total="Sum" Caption="Got&#243;wka" Format="{0:n}" ID="colGotowka"></ea:GridColumn>
                        <ea:GridColumn Width="16" Align="Right" DataMember="Inne" Total="Sum" Caption="ROR" Format="{0:n}" ID="colRor"></ea:GridColumn>
                    </Columns>
                </ea:Grid>
            </p>
            <ea:SectionMarker id="SectionMarker3" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:DataRepeater>
        <p>
            <ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
            Zestawienie list płac<br />
            <ea:Grid id="Grid2" runat="server" RowTypeName="Soneta.Place.ListaPlac,Soneta.KadryPlace" OnBeforeRow="Grid2_BeforeRow">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
                    <ea:GridColumn DataMember="Numer.NumerPelny" Caption="Lista płac~Numer"></ea:GridColumn>
                    <ea:GridColumn Width="16" Align="Center" DataMember="Data" Caption="Lista płac~Data"></ea:GridColumn>
                    <ea:GridColumn Width="16" Align="Center" DataMember="DataWyplaty" Caption="Lista płac~Data wypłaty"></ea:GridColumn>
                    <ea:GridColumn Width="16" Align="Right" Total="Sum" Caption="Got&#243;wka" Format="{0:n}" ID="colLpGotowka"></ea:GridColumn>
                    <ea:GridColumn Width="16" Align="Right" Total="Sum" Caption="ROR" Format="{0:n}" ID="colLpRor"></ea:GridColumn>
                </Columns>
            </ea:Grid>
        </p>
        <eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
    </form>
</body>
</html>
